<?php
/*
Template Name: Company Registration
*/
acf_form_head();
get_header();
?>

<?php
$post_id = get_the_ID();
$featured_image_url = get_the_post_thumbnail_url($post_id, 'full');
$banner_url = $featured_image_url;

if ($banner_url == '') {
    $banner_url = get_field('common_banner_image', 'options')['url'];
}
?>
<section class="banner bg-cover bg-no-repeat flex h-[21rem] items-center relative w-full" style="background: url(<?php echo $banner_url; ?>) no-repeat;background-position: top;background-size: cover;">
    <div class="container relative top-[-1.5rem]">
        <div class="flex justify-center items-center">
            <div class="text-center flex flex-wrap flex-col">
                <h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none"><?php echo get_the_title(); ?></h1>
            </div>
        </div>
    </div>
</section>


<?php
echo do_shortcode('[custom_breadcrumbs]');
?>

<section class="company__registration">
    <div class="container">
        <div class="company_register__form">

            <?php if (is_user_logged_in()) : ?>
                <?php
                $user_id = get_current_user_id();

                // Check if this user already owns a company
                $args = array(
                    'post_type'  => 'company',
                    'post_status' => array('pending', 'publish'),
                    'meta_key'   => 'company_owner',
                    'meta_value' => $user_id,
                    'numberposts' => 1,
                );

                $company_posts = get_posts($args);

                if (!empty($company_posts)) {

                    $company = $company_posts[0];
                    $status  = get_post_status($company);
                    if ($status === 'pending') {
                        echo '<h2>Company Registration Pending</h2>';
                        echo '<p>Your company has been submitted and is pending approval. Please check back later.</p>';
                    } elseif ($status === 'publish') {
                        echo '<p>You\'ve already registered a company: <a href="' . esc_url(get_permalink($company)) . '">' . esc_html(get_the_title($company)) . '</a></p>';
                    }
                } else {

                    acf_form(array(
                        'post_id' => 'new_post',
                        'field_groups' => array(42), // Replace with your field group ID
                        'new_post' => array(
                            'post_type' => 'company',
                            'post_status' => 'pending',
                        ),
                        'html_submit_button'  => '<input type="submit" class="acf-button button button-primary button-large" value="Register Company" />',
                        'html_updated_message'  => '<div id="message" class="success"><p>Company registration submitted successfully! We will review it shortly.</p></div>',
                    ));
                }
                ?>

            <?php else : ?>
                <p>You must be <a href="<?php echo wp_login_url(get_permalink()); ?>">logged in</a> to register your company.</p>
            <?php endif; ?>

        </div>
    </div>
</section>

<?php
get_footer();
