<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package kiresu
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php // the_title( '<h1 class="entry-title">', '</h1>' ); 
		?>
	</header><!-- .entry-header -->

	<?php
	$thumbnail_id = get_post_thumbnail_id(get_the_ID());
	$image_url_array = wp_get_attachment_image_src($thumbnail_id, 'full');
	$image_url = $image_url_array[0];
	if ($image_url == '') {
		$image_url = get_field('common_banner_image', 'options')['url'];
	}
	?>
	<section class="banner bg-cover bg-no-repeat flex h-[21rem] items-center relative w-full" style="background-image: url(<?php echo $image_url; ?>)">
		<div class="container relative top-[-1.5rem]">
			<div class="flex justify-center items-center">
				<div class="text-center flex flex-wrap flex-col">
					<h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none"><?php echo get_the_title(); ?></h1>
				</div>
			</div>
		</div>
	</section>

	<?php
	echo do_shortcode('[custom_breadcrumbs]');
	?>

	<div class="entry-content">
		<div class="container">
			<?php
			the_content();

			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . esc_html__('Pages:', 'kiresu'),
					'after'  => '</div>',
				)
			);
			?>
		</div>
	</div><!-- .entry-content -->

	<?php if (get_edit_post_link()) : ?>
		<footer class="entry-footer">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__('Edit <span class="screen-reader-text">%s</span>', 'kiresu'),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post(get_the_title())
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->