<?php get_header(); ?>

<section class="banner bg-cover bg-no-repeat flex h-[20em] md:h-[30em] items-center relative w-full" style="background: url(<?php echo get_template_directory_uri() . '/assets/images/category-banner.jpg'; ?>) no-repeat;background-position: top;background-size: cover;">
    <div class="container">
        <div class="flex justify-center items-center">
            <div class="text-center flex flex-wrap flex-col">
                <h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none"><?php single_term_title(); ?></h1>
            </div>
        </div>
    </div>
</section>


<section class="discover-section relative mt-[-8.5em] md:mt-[-5em] lg:mt-[-5.5em]">
    <div class="container">
        <?php echo do_shortcode('[custom_search_form]'); ?>
    </div>
</section>


<section
    class="category-all py-space relative before:content-none sm:before:content-[''] before:w-[100px] 2xl:before:w-[172px] before:h-[55px] 2xl:before:h-[95px] before:bg-[url(<?php echo get_template_directory_uri() . '/assets/images/cloud-gray.png'; ?>)] before:bg-no-repeat before:bg-cover before:absolute before:bottom-0 before:left-0 before:z-20">
    <div class="container">
        <div class="flex flex-wrap gap-6 lg:gap-8 xl:gap-12">
            <?php
            if (have_posts()) :
                while (have_posts()) : the_post(); ?>

                    <div class="bg-white rounded-lg border border-secondary p-6 flex flex-col md:flex-row">
                        <div class="md:w-1/3 w-full mb-4 md:mb-0">
                            <img src="<?php echo get_field('company_images')[0]['url']; ?>" alt="samsung-category" class="w-full rounded-lg" />
                        </div>
                        <div class="md:w-2/3 w-full pl-0 md:pl-8 lg:pl-12">
                            <h2 class="text-3xl font-bold mb-2"><?php the_title(); ?></h2>
                            <p class="text-lg mb-2 flex items-center"><img class="me-2 w-5 h-5" src="<?php echo get_template_directory_uri() . '/assets/images/location-icon.svg'; ?>" alt="location-icon" /><?php echo get_field('city') . ', ', get_field('state'); ?></p>
                            <div class="flex items-center mb-2"><span class="text-primary text-2xl mr-2">★★★★★</span><span class="text-black-light font-medium">(10 Reviews)</span></div>
                            <p class="text-gray mb-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                            <div class="text-gray lg:pe-64 mb-7">
                                <?php
                                $terms = get_the_terms(get_the_ID(), 'item_category');
                                if (! is_wp_error($terms) && ! empty($terms)) :
                                ?>
                                    <ul class="grid grid-cols-1 md:grid-cols-2 font-medium">
                                        <?php foreach ($terms as $term) : ?>
                                            <li class="flex items-center"><img class="me-2" src="<?php echo get_template_directory_uri() . '/assets/images/check-circle.svg'; ?>" alt="check-circle" /> <?php echo esc_html($term->name); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <button class="btn bg-primary">Request price</button>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
        </div>

        <?php
                global $wp_query;
                // Custom pagination markup
                $total_pages = $wp_query->max_num_pages;

                if ($total_pages > 1) {
                    $current_page = max(1, get_query_var('paged'));

                    echo '<div class="flex flex-wrap justify-center text-xl space-x-3 mt-5 lg:mt-12">';

                    // Prev Button
                    if ($current_page > 1) {
                        echo '<a href="' . get_pagenum_link($current_page - 1) . '" class="bg-secondary font-medium rounded-full w-11 h-11 hover:bg-primary text-center flex items-center justify-center"><img class="mx-auto" src="' . get_template_directory_uri() . '/assets/images/left-a.png" alt="left" /></a>';
                    }

                    // Page Numbers
                    for ($i = 1; $i <= $total_pages; $i++) {
                        $active_class = $i == $current_page ? 'bg-primary text-white' : 'bg-secondary hover:bg-primary';
                        echo '<a href="' . get_pagenum_link($i) . '" class="' . $active_class . ' font-medium rounded-full w-11 h-11 text-center flex items-center justify-center">' . $i . '</a>';
                    }

                    // Next Button
                    if ($current_page < $total_pages) {
                        echo '<a href="' . get_pagenum_link($current_page + 1) . '" class="bg-secondary font-medium rounded-full w-11 h-11 hover:bg-primary text-center flex items-center justify-center"><img class="mx-auto" src="' . get_template_directory_uri() . '/assets/images/right-a.png" alt="right" /></a>';
                    }

                    echo '</div>';
                }
        ?>
    </div>
</section>
<?php

            else :
                echo '<p>No companies found in this category.</p>';
            endif;
?>

<section class="supply-marketplace bg-secondary py-space">
    <div class="container">
        <div class="div">
            <div class="heading-wrap text-center">
                <h2 class="title text-4xl lg:text-5xl font-bold text-center mb-8"><span class="font-normal block mb-2">Leading Kitchen and Restaurant</span> Supply Marketplace in India</h2>
                <p class="mb-4">
                    Kiresu is the leading catering equipment supplier in the India - serving the needs of restaurants, hotels and bars across the nation. We offer a comprehensive range of professional catering equipment; including
                    innovative appliances machines from Buffalo, eco-friendly catering supplies from Fiesta and much more. With 40 years of industry experience, we take pride in providing the largest assortment of competitively priced
                    commercial kitchen equipment. With an impressive selection of over 31,000 products, you're sure to find exactly what you're looking for.
                </p>
                <p>
                    At Kiresu, we offer next-day delivery across most lines. This means that you can get new equipment delivered to your door and up and running in less than 24 hours. We also offer unpacking and positioning services for
                    Polar items such as fridges and freezers – all at no additional cost. If you require even faster service, our nationwide catering equipment stores offer the convenience of click-and-collect for both trade and public
                    customers.
                </p>
            </div>
        </div>
    </div>
</section>

<section class="accordion-main py-space">
    <div class="container">
        <div class="heading-wrap lg:mb-12 mb-8 text-center">
            <h2 class="title text-4xl lg:text-5xl font-bold"><span class="font-normal mb-2">Frequently Asked </span>Questions</h2>
        </div>
        <div class="space-y-4">
            <div class="border border-solid border-secondary rounded-xl">
                <button class="flex justify-between items-center w-full p-4 text-left lg:text-2xl font-bold accordion-btn md:p-6">
                    I need to request a quotation, how do I do this?
                    <span class="icon text-xl">−</span>
                </button>
                <div class="accordion-content px-4 pb-4 md:pb-6 md:px-6 lg:text-lg text-gray">
                    If you need to access an instant quote, securing your pricing for up to 30 days, you can now do this online! Simply add the relevant items to your basket and select 'Request a Quote' on the basket page. You will then be asked to select a reason for your quote, once you have done this, your quote will be processed.
                </div>
            </div>
            <div class="border border-solid border-secondary rounded-xl">
                <button class="flex justify-between items-center w-full p-4 text-left lg:text-2xl font-bold accordion-btn md:p-6">
                    I've got an issue with my product, what do I do?
                    <span class="icon w-5 h-5 border-2 rounded-full flex justify-center items-center font-normal text-sm">+</span>
                </button>
                <div class="accordion-content px-4 pb-4 md:pb-6 md:px-6 lg:text-lg text-gray hidden">
                    Please contact our support team with your order number and product issue. We'll assist you promptly.
                </div>
            </div>
            <div class="border border-solid border-secondary rounded-xl">
                <button class="flex justify-between items-center w-full p-4 text-left lg:text-2xl font-bold accordion-btn md:p-6">
                    I'm unsure which product to buy, can you help me?
                    <span class="icon w-5 h-5 border-2 rounded-full flex justify-center items-center font-normal text-sm">+</span>
                </button>
                <div class="accordion-content px-4 pb-4 md:pb-6 md:px-6 lg:text-lg text-gray hidden">
                    Absolutely! Contact our customer service or use the live chat for product recommendations.
                </div>
            </div>
            <div class="border border-solid border-secondary rounded-xl">
                <button class="flex justify-between items-center w-full p-4 text-left lg:text-2xl font-bold accordion-btn md:p-6">
                    How do I return product, If it is damage?
                    <span class="icon w-5 h-5 border-2 rounded-full flex justify-center items-center font-normal text-sm">+</span>
                </button>
                <div class="accordion-content px-4 pb-4 md:pb-6 md:px-6 lg:text-lg text-gray hidden">
                    Damaged products can be returned easily. Report the damage within 48 hours for a free replacement or refund.
                </div>
            </div>
        </div>
        <div class="text-center mt-6 lg:mt-10"><button class="btn bg-primary">View more FAQs</button></div>
    </div>
</section>

<?php get_footer(); ?>