<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package kiresu
 */


get_header();

?>
<section class="banner bg-cover bg-no-repeat flex h-[21rem] items-center relative w-full" style="background: url(<?php echo get_template_directory_uri() . '/assets/images/category-banner.jpg'; ?>) no-repeat;background-position: top;background-size: cover;">
	<div class="container relative top-[-1.5rem]">
		<div class="flex justify-center items-center">
			<div class="text-center flex flex-wrap flex-col">
				<h1 class="mb-3 font-bold text-4xl xl:text-7xl text-white uppercase leading-none">Search Results for: <?php echo $search_term; ?> <?php echo $search_city != '' ? 'in ' . $search_city : ''; ?></h1>
			</div>
		</div>
	</div>
</section>

<section class="discover-section relative mt-[-7.8rem] md:mt-[-4.5rem]">
	<div class="container">
		<?php echo do_shortcode('[custom_search_form]'); ?>
	</div>
</section>



<section
	class="category-all py-space relative before:content-none sm:before:content-[''] before:w-[6.9rem] before:h-[3.8rem] before:bg-[url(<?php echo get_template_directory_uri() . '/assets/images/cloud-gray.png'; ?>)] before:bg-no-repeat before:bg-cover before:absolute before:bottom-0 before:left-0 before:z-20">
	<div class="container">

		<?php if (have_posts()) : ?>
			<div class="flex gap-6 xl:gap-10 flex-col">
				<?php while (have_posts()) : the_post(); ?>

					<div class="bg-white rounded-lg border border-gray-dark p-3 pb-5 xl:p-5 flex flex-col md:flex-row">
						<div class="md:w-1/3 w-full mb-4 md:mb-0">
							<a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('company_images')[0]['url']; ?>" alt="samsung-category" class="w-full rounded-lg h-full object-cover" /></a>
						</div>
						<div class="md:w-2/3 w-full pl-0 md:pl-10">
							<h2 class="text-2xl font-bold mb-2">
								<a href="<?php the_permalink(); ?>">
									<?php the_title(); ?>
								</a>
							</h2>

							<p class="flex items-center"><img class="me-2 w-3" src="<?php echo get_template_directory_uri() . '/assets/images/location-icon.svg'; ?>" alt="location-icon" /><?php echo get_field('city') . ', ', get_field('state'); ?></p>
							<?php
							$company_id = get_the_ID(); // Assuming this is inside the single company template

							$args = [
								'post_type'      => 'review',
								'post_status'    => 'publish',
								'posts_per_page' => -1,
								'meta_query'     => [
									[
										'key'   => 'company_id',
										'value' => $company_id,
										'compare' => '='
									]
								]
							];

							$reviews = get_posts($args);
							$total_reviews = count($reviews);
							$total_rating = 0;

							foreach ($reviews as $review) {
								$rating = get_post_meta($review->ID, 'rating', true);
								$total_rating += intval($rating);
							}

							$average_rating = $total_reviews > 0 ? round($total_rating / $total_reviews, 1) : 0;

							// Convert average rating (out of 5) to percentage for width
							$filled_width = ($average_rating / 5) * 100;
							?>
							<div class="flex items-center gap-2 font-medium my-3 text-sm">
								<div class="stars text-gray-dark flex text-[15px]">
									<div class="rating-stars relative">
										<div class="empty stars text-gray-dark flex">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
										<div class="filled stars text-primary flex absolute top-0 left-0 overflow-hidden" style="width: <?php echo $filled_width; ?>%">
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
											<i class="fas fa-star"></i>
										</div>
									</div>
								</div>
								<p class="text-black-light"><?php echo $total_reviews; ?> Review<?php echo $total_reviews <= 1 ? '' : 's'; ?></p>
							</div>
							<p class="mb-3"><?php echo get_field('company_short_description'); ?></p>
							<div class="lg:pe-48 mb-5 font-semibold">
								<?php
								$terms = get_the_terms(get_the_ID(), 'item_category');
								if (! is_wp_error($terms) && ! empty($terms)) :
								?>
									<ul class="grid grid-cols-1 md:grid-cols-2 font-medium gap-1 gap-md-0">
										<?php foreach ($terms as $term) : ?>
											<li class="flex items-center"><img class="me-2" src="<?php echo get_template_directory_uri() . '/assets/images/check-circle.svg'; ?>" alt="check-circle" /> <?php echo esc_html($term->name); ?></li>
										<?php endforeach; ?>
									</ul>
								<?php endif; ?>
							</div>
							<a class="btn bg-primary" href="<?php the_permalink(); ?>">Request price</a>
						</div>
					</div>
				<?php endwhile; ?>
			</div>

			<?php
			global $wp_query;
			$total_pages = $wp_query->max_num_pages;
			$current_page = max(1, get_query_var('paged'));

			// Preserve existing query vars
			$query_args = [];
			if (!empty($_GET['s'])) {
				$query_args['s'] = sanitize_text_field($_GET['s']);
			}
			if (!empty($_GET['city'])) {
				$query_args['city'] = sanitize_text_field($_GET['city']);
			}

			if ($total_pages > 1) {

				echo '<div class="flex flex-wrap justify-center text-base space-x-2 mt-10">';

				// Prev
				if ($current_page > 1) {
					$prev_url = (add_query_arg($query_args, get_pagenum_link($current_page - 1)));
					echo '<a href="' . $prev_url . '" class="bg-secondary font-medium rounded-full w-10 h-10 hover:bg-primary text-center"><img class="mx-auto w-2" src="' . get_template_directory_uri() . '/assets/images/left-a.png" alt="left" /></a>';
				}

				// Pages
				for ($i = 1; $i <= $total_pages; $i++) {
					$page_url = (add_query_arg($query_args, get_pagenum_link($i)));
					$active_class = $i == $current_page ? 'bg-primary flex items-center justify-center' : 'flex items-center justify-center bg-secondary hover:bg-primary';
					echo '<a href="' . $page_url . '" class="' . $active_class . ' font-medium rounded-full w-8 h-8 hover:bg-primary text-center">' . $i . '</a>';
				}

				// Next
				if ($current_page < $total_pages) {
					$next_url = (add_query_arg($query_args, get_pagenum_link($current_page + 1)));
					echo '<a href="' . $next_url . '" class="bg-secondary font-medium rounded-full w-10 h-10 hover:bg-primary text-center"><img class="mx-auto w-2" src="' . get_template_directory_uri() . '/assets/images/right-a.png" alt="right" /></a>';
				}

				echo '</div>';
			}
			?>


		<?php else : ?>
			<p>No results found.</p>
		<?php endif; ?>

	</div>
</section>

<?php
wp_reset_postdata();
get_footer();
?>