document.querySelectorAll(".tab-btn").forEach((button) => {
  button.addEventListener("click", function () {
    // Remove active class from all buttons
    document
      .querySelectorAll(".tab-btn")
      .forEach((btn) => btn.classList.remove("active"));
    // Hide all content sections
    document
      .querySelectorAll(".tab-content")
      .forEach((content) => content.classList.remove("active"));

    // Add active class to clicked button and corresponding content
    this.classList.add("active");
    const tabId = this.getAttribute("data-tab");
    document.getElementById(tabId).classList.add("active");
  });
});

function getQueryParam(param) {
  const urlParams = new URLSearchParams(window.location.search);
  return urlParams.get(param);
}

jQuery(document).ready(function ($) {
  const updated = getQueryParam("updated");
  if (updated === "true") {
    setTimeout(() => {
      $("#message").fadeOut();

      // Remove the 'updated' parameter from the URL
      const url = new URL(window.location);
      url.searchParams.delete("updated");
      window.history.replaceState({}, document.title, url.toString());
    }, 3000);
  }

  $.getJSON(customSearchData.jsonUrl, function (data) {
    const $city = $("#city-select");
    let allCities = [];

    // Flatten all cities from all states
    Object.values(data).forEach((cityArray) => {
      allCities = allCities.concat(cityArray);
    });

    // Remove duplicates and sort alphabetically
    allCities = [...new Set(allCities)].sort();

    // Add options to the city dropdown
    allCities.forEach((city) => {
      $city.append(`<option value="${city}">${city}</option>`);
    });

    // Initialize Select2
    $city.select2({
      placeholder: "Select City",
      allowClear: true,
    });

    // Preselect city from URL
    const urlParams = new URLSearchParams(window.location.search);
    const selectedCity = urlParams.get("city");
    if (selectedCity) {
      $city.val(selectedCity).trigger("change");
    }
  });

  $(".customer-slider").owlCarousel({
    loop: true,
    margin: 0,
    nav: true,
    dots: false,
    autoplay: true,
    autoplayTimeout: 3000,
    responsive: {
      0: {
        loop: true,
        items: 1,
      },
      768: {
        items: 2,
        margin: 20,
      },
      992: {
        items: 3,
        margin: 20,
        loop: true,
        MouseDrag: false,
        touchDrag: false,
      },
      1200: {
        margin: 30,
      },
    },
  });

  $(".vs-update-slider").owlCarousel({
    loop: true,
    margin: 20,
    nav: true,
    dots: false,
    autoplay: true,
    autoplayTimeout: 3000,
    responsive: {
      0: {
        items: 1,
      },
      768: {
        items: 3,
        margin: 20,
      },
      992: {
        items: 3,
        margin: 20,
        MouseDrag: false,
        touchDrag: false,
      },
    },
  });

  $(".manufacutre-slider").owlCarousel({
    loop: true,
    margin: 0,
    nav: true,
    dots: false,
    autoplay: true,
    autoplayTimeout: 3000,
    responsive: {
      0: {
        loop: true,
        items: 1,
      },
      768: {
        items: 2,
        margin: 20,
      },
      992: {
        items: 3,
        margin: 20,
        loop: true,
        MouseDrag: false,
        touchDrag: false,
      },
      1200: {
        margin: 30,
      },
    },
  });

  $("#form__company_detail")
    .find('input:not([type="submit"]), textarea')
    .addClass("w-full px-2 py-2 rounded-md outline-none");
  $("#form__company_detail")
    .find('input[type="submit"]')
    .addClass("btn btn-transparent hover:border-black");

  $(".double-row-carousel").owlCarousel({
    loop: true,
    margin: 20,
    nav: true,
    dots: false,
    autoplay: true,
    responsive: {
      0: { items: 1 },
      768: { items: 1 },
      1024: { items: 1 },
    },
  });
});

const menuToggle = document.getElementById("menu-toggle");
const mobileMenu = document.getElementById("mobile-menu");

menuToggle.addEventListener("click", () => {
  if (mobileMenu.classList.contains("max-h-0")) {
    mobileMenu.classList.remove("max-h-0");
    mobileMenu.classList.add("max-h-[500px]");
  } else {
    mobileMenu.classList.add("max-h-0");
    mobileMenu.classList.remove("max-h-[500px]");
  }
});

// Toggle submenus in mobile
document.querySelectorAll(".submenu-toggle").forEach((button) => {
  button.addEventListener("click", () => {
    const submenu = button.nextElementSibling;
    const icon = button.querySelector("svg");
    submenu.classList.toggle("hidden");
    icon.classList.toggle("rotate-180");
  });
});

const tabButtons = document.querySelectorAll(".tab-btn");
const tabContents = document.querySelectorAll(".tab-content");

tabButtons.forEach((button) => {
  button.addEventListener("click", () => {
    const target = button.getAttribute("data-tab");

    // Remove active class from all buttons
    tabButtons.forEach((btn) => btn.classList.remove("active-tab"));
    // Hide all content
    tabContents.forEach((tab) => tab.classList.add("hidden"));

    // Show current content
    document.getElementById(target).classList.remove("hidden");
    button.classList.add("active-tab");
  });
});

// Accordion functionality
document.querySelectorAll(".accordion-btn").forEach((btn) => {
  btn.addEventListener("click", () => {
    const content = btn.nextElementSibling;
    const icon = btn.querySelector(".icon");

    const isOpen = !content.classList.contains("hidden");

    // Close all accordions
    document
      .querySelectorAll(".accordion-content")
      .forEach((c) => c.classList.add("hidden"));
    document
      .querySelectorAll(".accordion-btn .icon")
      .forEach((i) => (i.textContent = "+"));

    // Toggle current one
    if (!isOpen) {
      content.classList.remove("hidden");
      icon.textContent = "−";
    }
  });
});

const form = document.getElementById("reviewForm");
let isVisible = false;

function toggleForm() {
  if (!isVisible) {
    form.classList.remove("hidden");
    // Wait for the next paint to apply transitions
    requestAnimationFrame(() => {
      form.classList.remove("opacity-0", "scale-95");
      form.classList.add("opacity-100", "scale-100");
    });
  } else {
    form.classList.remove("opacity-100", "scale-100");
    form.classList.add("opacity-0", "scale-95");
    // Wait for transition to complete, then hide
    setTimeout(() => {
      form.classList.add("hidden");
    }, 500); // Match duration-500
  }
  isVisible = !isVisible;
}

function submitReview(event) {
  if (event) event.preventDefault();
  const text = document.getElementById("reviewText").value;
  const fullName = document.querySelector('[name="full_name"]').value;
  const title = document.querySelector('[name="your_title"]').value;
  const company_id = document.querySelector('[name="company_id"]').value;
  const current_user_id = document.querySelector('[name="current_user_id"]').value;
  const rating = document.querySelector('input[name="rating"]:checked');
  const responseMessage = document.querySelector(".response-message");

  // Hide old message
  responseMessage.style.display = "none";
  responseMessage.textContent = "";
  responseMessage.classList.remove("text-green-600", "text-red-600");

  if (!text.trim() || !fullName.trim() || !title.trim() || !rating) {
    responseMessage.textContent =
      "Please complete all fields before submitting.";
    responseMessage.classList.add("text-red-600");
    responseMessage.style.display = "block";
    return;
  }

  const formData = new FormData();
  formData.append("action", "submit_review");
  formData.append("full_name", fullName);
  formData.append("your_title", title);
  formData.append("rating", rating.value);
  formData.append("reviewText", text);
  formData.append("company_id", company_id);
  formData.append("current_user_id", current_user_id);

  fetch(ajax_object.ajax_url, {
    method: "POST",
    credentials: "same-origin",
    body: formData,
  })
    .then((response) => response.json())
    .then((data) => {
      if (data.success) {
        responseMessage.textContent =
          "Your review has been submitted successfully.";
        responseMessage.classList.add("text-green-600");
        responseMessage.style.display = "block";

        document.getElementById("reviewText").value = "";
        document.querySelector('[name="full_name"]').value = "";
        document.querySelector('[name="your_title"]').value = "";
        document
          .querySelectorAll('input[name="rating"]')
          .forEach((r) => (r.checked = false));
        setTimeout(() => {
          toggleForm(); // Close form after 3 seconds
          setTimeout(() => {
            responseMessage.style.display = "none";
          }, 600); // Wait for toggle animation to complete (e.g., 500ms + buffer)
        }, 3000);
      } else {
        responseMessage.textContent =
          data.data || "Submission failed. Please try again.";
        responseMessage.classList.add("text-red-600");
        responseMessage.style.display = "block";
      }
    })
    .catch(() => {
      responseMessage.textContent = "Something went wrong. Please try again.";
      responseMessage.classList.add("text-red-600");
      responseMessage.style.display = "block";
    });
}

document.addEventListener("DOMContentLoaded", function () {
  const btn = document.getElementById("show-more-faq");
  if (btn) {
    btn.addEventListener("click", function () {
      const hiddenFaqs = document.querySelectorAll(".extra-faq");
      hiddenFaqs.forEach((el) => el.classList.remove("hidden"));
      btn.style.display = "none"; // hide button after click
    });
  }
});
