<?php get_header(); ?>

<?php
$thumbnail_id = get_post_thumbnail_id(get_the_ID());
$image_url_array = wp_get_attachment_image_src($thumbnail_id, 'full');
$image_url = $image_url_array[0];
if ($image_url == '') {
    $image_url = get_field('common_banner_image', 'options')['url'];
}
?>
<section class="banner bg-cover bg-no-repeat flex h-[33rem] items-center relative w-full" style="background-image: url(<?php echo $image_url; ?>)">
    <div class="container relative top-[-1.8rem]">
        <div class="flex justify-center items-center">
            <div class="text-center flex flex-wrap flex-col">
                <figure class="mb-5"><img class="mx-auto w-[7rem]" src="<?php echo get_template_directory_uri() . '/assets/images/cloud-white.png'; ?>" title="cloud-white" alt="cloud-white" /></figure>
                <h1 class="mb-3 font-bold text-4xl xl:text-5xl 2xl:text-7xl text-white uppercase leading-none"><?php echo get_field('banner_title'); ?></h1>
                <p class="text-2xl xl:text-4xl text-white font-semibold leading-none"> <?php echo get_field('banner_subtitle'); ?></p>
            </div>
        </div>
    </div>
</section>

<section class="discover-section relative mt-[-7.8rem] md:mt-[-4.5rem]">
    <div class="container">
        <?php echo do_shortcode('[custom_search_form]'); ?>
    </div>
</section>

<section class="product-category py-space">
    <div class="container">
        <div class="heading-wrap lg:mb-10 mb-6">
            <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug"><?php echo get_field('product_category_section_heading'); ?></h2>
        </div>
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-5">
            <?php
            $terms = get_terms([
                'taxonomy'   => 'item_category',
                'hide_empty' => false,
                'parent'     => 0,
            ]);

            if (!empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $term_link = get_term_link($term);
                    echo '<div class="relative border border-gray-dark rounded-xl py-7 pb-12 px-7">';
                    echo '<h4 class="text-lg font-bold mb-3 capitalize leading-5">' . esc_html($term->name) . '</h4>';

                    // Get up to 7 child categories
                    $children = get_terms([
                        'taxonomy'   => 'item_category',
                        'hide_empty' => false,
                        'parent'     => $term->term_id,
                        'number'     => 7,
                    ]);

                    if (!empty($children) && !is_wp_error($children)) {
                        echo '<ul class="space-y-1">';
                        foreach ($children as $child) {
                            $child_link = get_term_link($child);
                            echo '<li class="block"><a class="hover:text-black hover:border hover:border-t-0 hover:border-r-0 hover:border-l-0" href="' . esc_url($child_link) . '">' . esc_html($child->name) . '</a></li>';
                        }
                        echo '</ul>';
                    }
                    echo '<a class="absolute right-0 bottom-0 btn-viewall" href="' . esc_url($term_link) . '">View All</a>';
                    echo '</div>';
                }
            }
            ?>
        </div>
    </div>
</section>

<section class="across-categories bg-secondary py-space">
    <div class="container">
        <div class="heading-wrap lg:mb-10 mb-6">
            <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug">
                <?php echo get_field('tab_section_heading'); ?>
            </h2>
        </div>
        <?php
        $parent_terms = get_terms([
            'taxonomy'   => 'item_category',
            'hide_empty' => false,
            'parent'     => 0,
        ]);

        if (!empty($parent_terms) && !is_wp_error($parent_terms)): ?>

            <div class="flex flex-wrap gap-y-8 lg:gap-y-0">

                <!-- Left Category Tabs -->
                <div class="bg-primary rounded-xl w-full md:w-1/3 py-4">
                    <ul class="text-base font-semibold">
                        <?php
                        $i = 1;
                        foreach ($parent_terms as $index => $term): ?>
                            <li><a class="tab-btn cursor-pointer px-6 py-3 block hover:bg-gradient-to-r text-black hover:from-[#e4d319] hover:to-[#efdf32] relative hover:after:content-[''] hover:after:w-0 after:h-0 hover:after:border-t-[10px] hover:after:border-t-transparent hover:after:border-l-[10px] hover:after:border-l-primary hover:after:border-l-red-500 hover:after:border-b-[10px] hover:after:border-b-transparent hover:after:absolute hover:after:right-[-0.5em] active-tab <?php echo $i == 1 ? 'active' : ''; ?>" data-tab="<?php echo esc_html($term->slug); ?>"><?php echo esc_html($term->name); ?></a></li>
                        <?php
                            $i++;
                        endforeach; ?>
                    </ul>
                </div>

                <!-- Right Company List -->
                <div class="md:pl-10 w-full md:w-2/3">
                    <?php foreach ($parent_terms as $index => $term): ?>

                        <div class="tab-content <?php echo $index != 0 ? 'hidden' : ''; ?>" id="<?php echo esc_html($term->slug); ?>">
                            <div class="flex flex-wrap items-center justify-between mb-5">
                                <h3 class="text-lg xl:text-xl font-bold mb-2 sm:mb-0 w-full md:w-auto">
                                    List of <?php echo esc_html($term->name); ?> Companies
                                </h3>

                                <a class="font-semibold flex items-center hover:underline underline-offset-2 text-sm text-black" href="<?php echo esc_url(get_term_link($term)); ?>">View all <img class="w-[0.4rem] ms-1" src="<?php echo get_template_directory_uri() . '/assets/images/right-a.png'; ?>" alt="right-a"></a>
                            </div>
                            <div class="grid lg:grid-cols-2 gap-6">
                                <?php
                                // Fetch "company" posts assigned to this product_cat
                                $posts = get_posts([
                                    'post_type'      => 'company',
                                    'posts_per_page' => -1,
                                    'tax_query'      => [
                                        [
                                            'taxonomy' => 'item_category',
                                            'field'    => 'term_id',
                                            'terms'    => $term->term_id,
                                        ],
                                    ],
                                ]);

                                if ($posts):
                                    foreach ($posts as $post):
                                        setup_postdata($post); ?>
                                        <div class="bg-white p-4 rounded-xl flex items-center gap-x-5">
                                            <figure
                                                class="bg-secondary w-24 h-24 flex items-center justify-center rounded-xl p-2">
                                                <img src="<?php echo get_field('company_logo')['url']; ?>" alt="<?php echo get_field('company_logo')['alt']; ?>" />
                                            </figure>
                                            <div class="flex flex-wrap flex-col gap-2">
                                                <h3 class="text-base font-bold leading-normal">
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php the_title(); ?>
                                                    </a>
                                                </h3>
                                                <?php
                                                $company_id = get_the_ID(); // Assuming this is inside the single company template

                                                $args = [
                                                    'post_type'      => 'review',
                                                    'post_status'    => 'publish',
                                                    'posts_per_page' => -1,
                                                    'meta_query'     => [
                                                        [
                                                            'key'   => 'company_id',
                                                            'value' => $company_id,
                                                            'compare' => '='
                                                        ]
                                                    ]
                                                ];

                                                $reviews = get_posts($args);
                                                $total_reviews = count($reviews);
                                                $total_rating = 0;

                                                foreach ($reviews as $review) {
                                                    $rating = get_post_meta($review->ID, 'rating', true);
                                                    $total_rating += intval($rating);
                                                }

                                                $average_rating = $total_reviews > 0 ? round($total_rating / $total_reviews, 1) : 0;

                                                // Convert average rating (out of 5) to percentage for width
                                                $filled_width = ($average_rating / 5) * 100;
                                                ?>
                                                <div class="flex items-center">
                                                    <div class="stars text-gray-dark flex">
                                                        <div class="rating-stars relative">
                                                            <div class="empty stars text-gray-dark flex">
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                            </div>
                                                            <div class="filled stars text-primary flex absolute top-0 left-0 overflow-hidden" style="width: <?php echo $filled_width; ?>%">
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                                <i class="fas fa-star"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <span class="inline-block font-semibold text-black ms-2"><?php echo $average_rating; ?></span>
                                                </div>
                                                <p class="font-semibold underline underline-offset-4 text-sm"><?php echo $total_reviews; ?> Review<?php echo $total_reviews === 1 ? '' : 's'; ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach;
                                    wp_reset_postdata();
                                else: ?>
                                    <p>No companies found in this category.</p>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>


<section class="why-choose py-space">
    <div class="container">
        <div class="heading-wrap lg:mb-10 mb-6">
            <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug"><?php echo get_field('why_choose_kiresu_section')['title']; ?></h2>
        </div>
        <?php
        $why_choose_kiresu_section = get_field('why_choose_kiresu_section');
        if (!empty($why_choose_kiresu_section['why_choose_kiresu'])) {
        ?>
            <div class="grid md:grid-cols-3 gap-5 xl:gap-8 text-center">
                <?php
                foreach ($why_choose_kiresu_section['why_choose_kiresu'] as $item) {
                    $image = $item['image'];
                    $title = $item['title'];
                    $description = $item['description'];
                ?>
                    <div class="relative border border-gray-dark rounded-xl p-8">
                        <figure class="w-24 xl:w-32 h-24 xl:h-32 rounded-full bg-primary flex items-center justify-center mb-4 xl:mb-8 mx-auto">
                            <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
                        </figure>
                        <div class="xl:text-lg">
                            <p><?php echo $description; ?></p>
                        </div>
                        <h4 class="text-xl xl:text-2xl font-bold uppercase"><?php echo $title; ?></h4>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</section>

<?php if (have_rows('customer_reviews')) { ?>
    <section class="customer-says py-space pt-0">
        <div class="container">
            <div class="heading-wrap lg:mb-10 mb-6">
                <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug"><?php echo get_field('customer_reviews_section_heading'); ?></h2>
            </div>
            <div class="owl-carousel customer-slider">
                <?php while (have_rows('customer_reviews')) : the_row(); ?>
                    <?php
                    $customer_name = get_sub_field('customer_name');
                    $review_title = get_sub_field('review_title');
                    $review_description = get_sub_field('review_description');
                    $rating = (int) get_sub_field('rating');
                    $review_date_raw = get_sub_field('review_date');
                    $review_location = get_sub_field('review_location');

                    $review_date = DateTime::createFromFormat('d/m/Y', $review_date_raw);
                    $now = new DateTime();

                    if ($review_date) {
                        $is_future = $review_date > $now;
                        $interval = $now->diff($review_date);

                        if ($interval->y > 0) {
                            $relative = $interval->y . ' year' . ($interval->y > 1 ? 's' : '');
                        } elseif ($interval->m > 0) {
                            $relative = $interval->m . ' month' . ($interval->m > 1 ? 's' : '');
                        } elseif ($interval->d > 0) {
                            $relative = $interval->d . ' day' . ($interval->d > 1 ? 's' : '');
                        } else {
                            $relative = 'Today';
                        }

                        if ($relative !== 'Today') {
                            $relative = $is_future ? 'in ' . $relative : $relative . ' ago';
                        }
                    }

                    ?>
                    <div class="item">
                        <div class="bg-white rounded-xl p-6 border border-gray-dark">
                            <div class="empty stars text-primary flex text-[15px] mb-4">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <i class="fa<?php echo $i <= $rating ? 's' : 'r'; ?> fa-star"></i>
                                <?php endfor; ?>
                            </div>
                            <h3 class="text-lg font-bold mb-1"><?php echo $review_title; ?></h3>
                            <p class="mb-3"><?php echo $review_description; ?></p>
                            <div class="font-bold text-black"><?php echo $customer_name; ?></div>
                            <div><?php echo $review_location . ' . ' . esc_html($relative); ?></div>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>
            <div class="mt-9 text-center">
                <a href="<?php echo get_field('view_all_reviews_button')['url']; ?>" class="btn bg-primary"><?php echo get_field('view_all_reviews_button')['title']; ?></a>
            </div>
        </div>
    </section>
<?php } ?>

<section class="supply-marketplace bg-secondary py-space">
    <div class="container">
        <div class="heading-wrap lg:mb-10 mb-6">
            <h2 class="title text-3xl xl:text-4xl font-bold text-center lg:leading-snug"><?php echo get_field('supply_marketplace_section')['title']; ?></h2>
        </div>
        <div class="space-y-4 text-center">
            <?php echo get_field('supply_marketplace_section')['description']; ?>
        </div>
    </div>
</section>

<section class="restaurant-requirements py-space" style=" background-image: url('<?php echo get_field('request_quote_cta')['image']['url']; ?>');">
    <div class="container">
        <div class="flex justify-end">
            <div class="md:w-[55%] text-black">
                <div class="heading-wrap mb-3">
                    <h2 class="title text-3xl xl:text-4xl font-bold lg:leading-snug"><?php echo get_field('request_quote_cta')['title']; ?></h2>
                </div>
                <?php echo get_field('request_quote_cta')['description']; ?>
                <div class="mt-6">
                    <a class="btn btn-transparent hover:bg-black hover:text-primary hover:border-black" href="<?php echo get_field('request_quote_cta')['button']['url']; ?>"><?php echo get_field('request_quote_cta')['button']['title']; ?></a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>