<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package kiresu
 */

?>

<footer class="w-full bg-black text-white py-space pb-0">
	<div class="container">
		<div class="grid grid-cols-2 lg:grid-cols-4 gap-y-8 gap-x-4 pb-10">
			<div
				class="md:col-span-1 col-span-2 flex md:items-start items-center flex-col 2xl:items-start space-y-5">
				<a href="<?php echo site_url(); ?>" class="flex justify-center lg:justify-start">
					<img class="w-36" src="<?php echo get_field('footer_logo', 'options')['url']; ?>" title="<?php echo get_field('footer_logo', 'options')['title']; ?>" alt="<?php echo get_field('footer_logo', 'options')['alt']; ?>" />
				</a>
				<div class="font-medium">
					<ul class="space-y-2">
						<li class="flex items-center"><img class="mr-3" src="<?php echo get_template_directory_uri() . '/assets/images/email-icon.png'; ?>" title="email-icon"
								alt="email-icon" /><a href="mailto:<?php echo get_field('contact_details', 'options')['email']; ?>"><?php echo get_field('contact_details', 'options')['email']; ?></a></li>
						<li class="flex items-center"><img class="mr-3" src="<?php echo get_template_directory_uri() . '/assets/images/call-icon.png'; ?>" title="call-icon"
								alt="call-icon" /><a href="tel:<?php echo get_field('contact_details', 'options')['phone']; ?>"><?php echo get_field('contact_details', 'options')['phone']; ?></a></li>
					</ul>
				</div>

				<?php if (have_rows('social_media_details', 'options')) { ?>
					<div class="flex mt-4 space-x-4 sm:justify-center lg:mt-0">
						<?php
						while (have_rows('social_media_details', 'options')) : the_row();
							$social_media_icon = get_sub_field('social_media_icon');
							$social_media_link = get_sub_field('social_media_link');
						?>
							<a href="<?php echo $social_media_link; ?>" class="flex justify-center items-center hover:text-primary">
								<img style="width: 22px;" src="<?php echo $social_media_icon['url']; ?>" alt="<?php echo $social_media_icon['alt']; ?>">
							</a>
						<?php endwhile; ?>
					</div>
				<?php } ?>
			</div>

			<div class="lg:mx-auto text-left ">
				<h4 class="text-lg xl:text-xl font-bold text-white uppercase mb-4">Categories</h4>
				<?php
				wp_nav_menu([
					'theme_location' => 'primary-footer',
					'container' => false,
					'menu_class' => 'space-y-2 text-sm',
					'items_wrap' => '<ul class="%2$s">%3$s</ul>',
					'link_before' => '',
					'link_after'  => '',
					'fallback_cb' => false,
					'walker' => new class extends Walker_Nav_Menu {
						// Add 'hover:text-primary' to <a> elements
						function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
						{
							$class_names = 'hover:text-primary';
							$output .= '<li>';
							$output .= '<a href="' . esc_url($item->url) . '" class="' . $class_names . '">';
							$output .= apply_filters('the_title', $item->title, $item->ID);
							$output .= '</a>';
							$output .= '</li>';
						}
					}
				]);
				?>
			</div>


			<div class="lg:mx-auto text-left">
				<h4 class="text-lg font-bold text-white uppercase mb-3">Brands</h4>
				<?php
				wp_nav_menu([
					'theme_location' => 'footer-brands',
					'container' => false,
					'menu_class' => 'space-y-2 text-sm',
					'items_wrap' => '<ul class="%2$s">%3$s</ul>',
					'link_before' => '',
					'link_after'  => '',
					'fallback_cb' => false,
					'walker' => new class extends Walker_Nav_Menu {
						// Add 'hover:text-primary' to <a> elements
						function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
						{
							$class_names = 'hover:text-primary';
							$output .= '<li>';
							$output .= '<a href="' . esc_url($item->url) . '" class="' . $class_names . '">';
							$output .= apply_filters('the_title', $item->title, $item->ID);
							$output .= '</a>';
							$output .= '</li>';
						}
					}
				]);
				?>
			</div>
			<div class="lg:mx-auto text-left">
				<h4 class="text-lg font-bold text-white uppercase mb-3">About Us</h4>
				<?php
				wp_nav_menu([
					'theme_location' => 'footer-about_us',
					'container' => false,
					'menu_class' => 'space-y-2 text-sm',
					'items_wrap' => '<ul class="%2$s">%3$s</ul>',
					'link_before' => '',
					'link_after'  => '',
					'fallback_cb' => false,
					'walker' => new class extends Walker_Nav_Menu {
						// Add 'hover:text-primary' to <a> elements
						function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
						{
							$class_names = 'hover:text-primary';
							$output .= '<li>';
							$output .= '<a href="' . esc_url($item->url) . '" class="' . $class_names . '">';
							$output .= apply_filters('the_title', $item->title, $item->ID);
							$output .= '</a>';
							$output .= '</li>';
						}
					}
				]);
				?>
			</div>
		</div>
		<div class="border-t border-gray py-6 text-xs text-gray-light">
			<div class="flex flex-wrap items-center justify-center space-x-4 lg:space-y-0 space-y-2 text-center">
				<span class="text-gray-light"><?php echo get_field('copyright_text', 'options'); ?></span>

				<?php
				wp_nav_menu([
					'theme_location' => 'footer-privacy_policy',
					'container' => false,
					'menu_class' => 'flex flex-wrap items-center space-x-4 justify-center',
					'items_wrap' => '<ul class="%2$s">%3$s</ul>',
					'link_before' => '',
					'link_after'  => '',
					'fallback_cb' => false,
					'walker' => new class extends Walker_Nav_Menu {
						// Add 'hover:text-primary' to <a> elements
						function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
						{
							$class_names = 'hover:text-primary';
							$output .= '<li class="relative before:content-[\'\'] before:absolute before:h-[15px] before:border-l-[2px] before:border-[#555555] before:left-[-8px] before:top-[1px]">';
							$output .= '<a href="' . esc_url($item->url) . '" class="' . $class_names . '">';
							$output .= apply_filters('the_title', $item->title, $item->ID);
							$output .= '</a>';
							$output .= '</li>';
						}
					}
				]);
				?>
			</div>
		</div>
	</div>
</footer>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>